/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.ImmutableSortedAsList;
import org.python.google.common.collect.ImmutableSortedSet;
import org.python.google.common.collect.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableSortedSet<E>
extends ImmutableSortedSet<E> {
    private final transient ImmutableList<E> elements;

    RegularImmutableSortedSet(ImmutableList<E> immutableList, Comparator<? super E> comparator) {
        super(comparator);
        this.elements = immutableList;
        Preconditions.checkArgument(!immutableList.isEmpty());
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        try {
            return this.binarySearch(object) >= 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (!RegularImmutableSortedSet.hasSameComparator(collection, this.comparator()) || collection.size() <= 1) {
            return super.containsAll(collection);
        }
        Iterator iterator = this.iterator();
        Iterator<?> iterator2 = collection.iterator();
        Object obj = iterator2.next();
        try {
            while (iterator.hasNext()) {
                int n = this.unsafeCompare(iterator.next(), obj);
                if (n == 0) {
                    if (!iterator2.hasNext()) {
                        return true;
                    }
                    obj = iterator2.next();
                    continue;
                }
                if (n <= 0) continue;
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return false;
    }

    private int binarySearch(Object object) {
        Comparator comparator = this.comparator;
        return Collections.binarySearch(this.elements, object, comparator);
    }

    @Override
    boolean isPartialView() {
        return this.elements.isPartialView();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.elements.toArray(TArray);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (this.size() != set.size()) {
            return false;
        }
        if (RegularImmutableSortedSet.hasSameComparator(set, this.comparator)) {
            Iterator iterator = set.iterator();
            try {
                for (Object e : this) {
                    Object e2 = iterator.next();
                    if (e2 != null && this.unsafeCompare(e, e2) == 0) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return this.containsAll(set);
    }

    @Override
    public E first() {
        return this.elements.get(0);
    }

    @Override
    public E last() {
        return this.elements.get(this.size() - 1);
    }

    @Override
    ImmutableSortedSet<E> headSetImpl(E e) {
        return this.createSubset(0, this.findSubsetIndex(e));
    }

    @Override
    ImmutableSortedSet<E> subSetImpl(E e, E e2) {
        return this.createSubset(this.findSubsetIndex(e), this.findSubsetIndex(e2));
    }

    @Override
    ImmutableSortedSet<E> tailSetImpl(E e) {
        return this.createSubset(this.findSubsetIndex(e), this.size());
    }

    private int findSubsetIndex(E e) {
        int n = this.binarySearch(e);
        return n >= 0 ? n : -n - 1;
    }

    private ImmutableSortedSet<E> createSubset(int n, int n2) {
        if (n < n2) {
            return new RegularImmutableSortedSet<E>(this.elements.subList(n, n2), this.comparator);
        }
        return RegularImmutableSortedSet.emptySet(this.comparator);
    }

    @Override
    int indexOf(Object object) {
        int n;
        if (object == null) {
            return -1;
        }
        try {
            n = this.binarySearch(object);
        }
        catch (ClassCastException classCastException) {
            return -1;
        }
        return n >= 0 && this.elements.get(n).equals(object) ? n : -1;
    }

    @Override
    ImmutableList<E> createAsList() {
        return new ImmutableSortedAsList<E>(this, this.elements);
    }
}

